<?php
 /**
 * Plugin Name: Little Google Tools
 * Plugin URI: http://www.seohermit.com
 * Description: Easily add Google Analytics and Google Fonts to your website, as well as NAP Schema markup for SEO.
 * Version: 0.0.8
 * Author: SEO Hermit
 * Author URI: http://www.seohermit.com
 * License: 
 */

class Settings_Little_Google_Tools {

    private $ga_settings_key = 'lgt_ga_settings';
    private $gf_settings_key = 'lgt_gf_settings';
    private $nap_settings_key = 'lgt_nap_settings';
    private $lgt_options_key = 'lgt_options';
    private $lgt_settings_tabs = array();

    function __construct() {
        add_action( 'init', array( &$this, 'load_settings' ) );
        add_action( 'admin_init', array( &$this, 'register_ga_settings' ) );
        add_action( 'admin_init', array( &$this, 'register_gf_settings' ) );
        add_action( 'admin_init', array( &$this, 'register_nap_settings' ) );
        add_action( 'admin_menu', array( &$this, 'add_admin_menus' ) );
    }

    function load_settings() {
        $this->ga_settings = (array) get_option( $this->ga_settings_key );
        $this->gf_settings = (array) get_option( $this->gf_settings_key );
        $this->nap_settings = (array) get_option( $this->nap_settings_key );

        $this->ga_settings = array_merge( array(
            'ga_enabled' => '0'
        ), $this->ga_settings );
        $this->ga_settings = array_merge( array(
            'ga_id' => ''
        ), $this->ga_settings );
        $this->ga_settings = array_merge( array(
            'ga_display_advertising_features' => '0'
        ), $this->ga_settings );
        $this->gf_settings = array_merge( array(
            'gf_enabled' => '0'
        ), $this->gf_settings );
        $this->gf_settings = array_merge( array(
            'gf_fonts' => ''
        ), $this->gf_settings );
        $this->nap_settings = array_merge( array(
            'nap_enabled' => '0'
        ), $this->nap_settings );
        $this->nap_settings = array_merge( array(
            'nap_markup_location' => 'wp_footer'
        ), $this->nap_settings );
        $this->nap_settings = array_merge( array(
            'nap_type' => 'LocalBusiness'
        ), $this->nap_settings );
        $this->nap_settings = array_merge( array(
            'nap_name' => ''
        ), $this->nap_settings );
        $this->nap_settings = array_merge( array(
            'nap_address' => ''
        ), $this->nap_settings );
        $this->nap_settings = array_merge( array(
            'nap_city' => ''
        ), $this->nap_settings );
        $this->nap_settings = array_merge( array(
            'nap_state' => ''
        ), $this->nap_settings );
        $this->nap_settings = array_merge( array(
            'nap_zip' => ''
        ), $this->nap_settings );
        $this->nap_settings = array_merge( array(
            'nap_phone' => ''
        ), $this->nap_settings );
        $this->nap_settings = array_merge( array(
            'nap_hours_schema' => ''
        ), $this->nap_settings );
        $this->nap_settings = array_merge( array(
            'nap_hours_display' => ''
        ), $this->nap_settings );
        $this->nap_settings = array_merge( array(
            'nap_css' => ''
        ), $this->nap_settings );
    }

    function register_ga_settings() {
        $this->lgt_settings_tabs[$this->ga_settings_key] = 'Google Analytics';
        register_setting( $this->ga_settings_key, $this->ga_settings_key );
        add_settings_section( 'section_ga', 'Google Analytics Settings', array( &$this, 'section_ga_desc' ), $this->ga_settings_key );
        add_settings_field( 'ga_enabled', 'Enable Google Analytics', array( &$this, 'field_ga_enabled' ), $this->ga_settings_key, 'section_ga' );
        add_settings_field( 'ga_id', 'Tracking ID<div class="subt">e.g. "UA-000000-01"</div>', array( &$this, 'field_ga_id' ), $this->ga_settings_key, 'section_ga' );
        add_settings_field( 'ga_display_advertising_features', 'Enable Display Advertising Features for Universal Analytics', array( &$this, 'field_ga_display_advertising_features' ), $this->ga_settings_key, 'section_ga' );
    }

    function section_ga_desc() {
        echo 'Inserts the Google Analytics tracking code into the &lt;head&gt; section of your website. Google Analytics may take up to 36 hours to detect and confirm the presence of a tracking code on your website.';
    }

    function field_ga_enabled() {
        ?>
        <input type="checkbox" name="<?php echo $this->ga_settings_key; ?>[ga_enabled]" value="1" <?php checked( '1', $this->ga_settings['ga_enabled'] ); ?> />
        <?php
    }

    function field_ga_id() {
        ?>
        <input type="text" name="<?php echo $this->ga_settings_key; ?>[ga_id]" value="<?php echo esc_attr( $this->ga_settings['ga_id'] ); ?>" />
        <?php
    }

    function field_ga_display_advertising_features() {
        ?>
        <input type="checkbox" name="<?php echo $this->ga_settings_key; ?>[ga_display_advertising_features]" value="1" <?php checked( '1', $this->ga_settings['ga_display_advertising_features'] ); ?> />
        <?php
    }

    function register_gf_settings() {
        $this->lgt_settings_tabs[$this->gf_settings_key] = 'Google Fonts';
        register_setting( $this->gf_settings_key, $this->gf_settings_key );
        add_settings_section( 'section_gf', 'Google Fonts Settings', array( &$this, 'section_gf_desc' ), $this->gf_settings_key );
        add_settings_field( 'gf_enabled', 'Enable Google Fonts', array( &$this, 'field_gf_enabled' ), $this->gf_settings_key, 'section_gf' );
        add_settings_field( 'gf_fonts', 'Google Fonts', array( &$this, 'field_gf_fonts' ), $this->gf_settings_key, 'section_gf' );
    }

    function section_gf_desc() {
        echo 'Google Fonts contains over 800 fonts for use on the web. Click the &apos;Browse Google Fonts&apos; link below, select your desired fonts, and then paste the bolded portion of the embed tag provided by Google. The chosen fonts are then enqueued and ready for use within your CSS.';
    }

    function field_gf_enabled() {
        ?>
        <input type="checkbox" name="<?php echo $this->gf_settings_key; ?>[gf_enabled]" value="1" <?php checked( '1', $this->gf_settings['gf_enabled'] ); ?> />
        </td></tr><tr><th scope="row">Browse Fonts</th><td><a href="http://www.google.com/fonts" rel="nofollow" target="_blank">Browse Google Fonts</a>
        <?php
    }

    function field_gf_fonts() {
        ?>
        <input type="text" name="<?php echo $this->gf_settings_key; ?>[gf_fonts]" value="<?php echo esc_attr( $this->gf_settings['gf_fonts'] ); ?>" />
		<div class="subt">Paste the bolded portion of the embed tag you create on the Google Fonts website. For example:<br /><strong>Open+Sans:300,300i,400,600i,700,700i,800|Roboto:100,300,400,500,500i,900,900i</strong></div>
        <?php
    }

    function register_nap_settings() {
        $this->lgt_settings_tabs[$this->nap_settings_key] = 'NAP Schema';
        register_setting( $this->nap_settings_key, $this->nap_settings_key );
        add_settings_section( 'section_nap', 'NAP Schema Settings', array( &$this, 'section_nap_desc' ), $this->nap_settings_key );
        add_settings_field( 'nap_enabled', 'Enable NAP Schema', array( &$this, 'field_nap_enabled' ), $this->nap_settings_key, 'section_nap' );
        add_settings_field( 'nap_markup_location', 'Schema Location', array( &$this, 'field_nap_markup_location' ), $this->nap_settings_key, 'section_nap' );
        add_settings_field( 'nap_type', 'Entity Type<div class="subt">If unsure, use LocalBusiness.</div>', array( &$this, 'field_nap_type' ), $this->nap_settings_key, 'section_nap' );
        add_settings_field( 'nap_name', 'Business Name', array( &$this, 'field_nap_name' ), $this->nap_settings_key, 'section_nap' );
        add_settings_field( 'nap_address', 'Address', array( &$this, 'field_nap_address' ), $this->nap_settings_key, 'section_nap' );
        add_settings_field( 'nap_city', 'City', array( &$this, 'field_nap_city' ), $this->nap_settings_key, 'section_nap' );
        add_settings_field( 'nap_state', 'State', array( &$this, 'field_nap_state' ), $this->nap_settings_key, 'section_nap' );
        add_settings_field( 'nap_zip', 'Zip Code', array( &$this, 'field_nap_zip' ), $this->nap_settings_key, 'section_nap' );
        add_settings_field( 'nap_phone', 'Telephone', array( &$this, 'field_nap_phone' ), $this->nap_settings_key, 'section_nap' );
        add_settings_field( 'nap_hours_schema', 'Hours (Schema)<div class="subt">e.g. "Mo,Tu,We,Th,Fr 9:00-17:00"</div>', array( &$this, 'field_nap_hours_schema' ), $this->nap_settings_key, 'section_nap' );
        add_settings_field( 'nap_hours_display', 'Hours (Display)<div class="subt">e.g. "Open weekdays, 9am-5pm"</div>', array( &$this, 'field_nap_hours_display' ), $this->nap_settings_key, 'section_nap' );
        add_settings_field( 'nap_css', 'Custom CSS<div class="subt">e.g. "font-size:14px;color:#FF0000;"</div>', array( &$this, 'field_nap_css' ), $this->nap_settings_key, 'section_nap' );
    }

    function section_nap_desc() {
        echo 'NAP is an acronym for Name, Address, and Phone Number. If you are a business, including your NAP on your website with complete and accurate Schema.org markup can provide a significant SEO benefit.';
    }

    function field_nap_enabled() {
        ?>
        <input type="checkbox" name="<?php echo $this->nap_settings_key; ?>[nap_enabled]" value="1" <?php checked( '1', $this->nap_settings['nap_enabled'] ); ?> />
        <?php
    }

    function field_nap_markup_location() {
        ?>
        <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_markup_location]" value="wp_footer" <?php checked( 'wp_footer', $this->nap_settings['nap_markup_location'] ); ?> /><strong>Site Footer</strong></div>
        <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_markup_location]" value="" <?php checked( '', $this->nap_settings['nap_markup_location'] ); ?> /><strong>Custom Location</strong></div>
        <div class="subt">If using Custom Location, embed your NAP Schema with the following PHP code or shortcode:<br /><strong>&lt;?php lgt_nap(); ?&gt;</strong> or <strong>[nap_schema]</strong></div>
        <?php
    }

    function field_nap_type() {
        ?>
        <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="Event" <?php checked( 'Event', $this->nap_settings['nap_type'] ); ?> />Event</div>
            <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="Organization" <?php checked( 'Organization', $this->nap_settings['nap_type'] ); ?> />Organization</div>
                <div class="sub">
                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="Corporation" <?php checked( 'Corporation', $this->nap_settings['nap_type'] ); ?> />Corporation</div>
                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="LocalBusiness" <?php checked( 'LocalBusiness', $this->nap_settings['nap_type'] ); ?> /><strong>LocalBusiness</strong></div>
                        <div class="subx2">
                            <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="AnimalShelter" <?php checked( 'AnimalShelter', $this->nap_settings['nap_type'] ); ?> />AnimalShelter</div>
                            <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="AutomotiveBusiness" <?php checked( 'AutomotiveBusiness', $this->nap_settings['nap_type'] ); ?> />AutomotiveBusiness</div>
                                <div class="subx3">
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="AutoBodyShop" <?php checked( 'AutoBodyShop', $this->nap_settings['nap_type'] ); ?> />AutoBodyShop</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="AutoDealer" <?php checked( 'AutoDealer', $this->nap_settings['nap_type'] ); ?> />AutoDealer</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="AutoPartsStore" <?php checked( 'AutoPartsStore', $this->nap_settings['nap_type'] ); ?> />AutoPartsStore</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="AutoRepair" <?php checked( 'AutoRepair', $this->nap_settings['nap_type'] ); ?> />AutoRepair</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="AutoWash" <?php checked( 'AutoWash', $this->nap_settings['nap_type'] ); ?> />AutoWash</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="GasStation" <?php checked( 'GasStation', $this->nap_settings['nap_type'] ); ?> />GasStation</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="MotorcycleDealer" <?php checked( 'MotorcycleDealer', $this->nap_settings['nap_type'] ); ?> />MotorcycleDealer</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="MotorcycleRepair" <?php checked( 'MotorcycleRepair', $this->nap_settings['nap_type'] ); ?> />MotorcycleRepair</div>
                                </div>
                            <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="EntertainmentBusiness" <?php checked( 'EntertainmentBusiness', $this->nap_settings['nap_type'] ); ?> />EntertainmentBusiness</div>
                                <div class="subx3">
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="AdultEntertainment" <?php checked( 'AdultEntertainment', $this->nap_settings['nap_type'] ); ?> />AdultEntertainment</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="MovieTheater" <?php checked( 'MovieTheater', $this->nap_settings['nap_type'] ); ?> />MovieTheater</div>
                                </div>
                            <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="FoodEstablishment" <?php checked( 'FoodEstablishment', $this->nap_settings['nap_type'] ); ?> />FoodEstablishment</div>
                                <div class="subx3">
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="Bakery" <?php checked( 'Bakery', $this->nap_settings['nap_type'] ); ?> />Bakery</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="BarOrPub" <?php checked( 'BarOrPub', $this->nap_settings['nap_type'] ); ?> />BarOrPub</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="Brewery" <?php checked( 'Brewery', $this->nap_settings['nap_type'] ); ?> />Brewery</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="FastFoodRestaurant" <?php checked( 'FastFoodRestaurant', $this->nap_settings['nap_type'] ); ?> />FastFoodRestaurant</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="Restaurant" <?php checked( 'Restaurant', $this->nap_settings['nap_type'] ); ?> />Restaurant</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="Winery" <?php checked( 'Winery', $this->nap_settings['nap_type'] ); ?> />Winery</div>
                                </div>
                            <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="HealthAndBeautyBusiness" <?php checked( 'HealthAndBeautyBusiness', $this->nap_settings['nap_type'] ); ?> />HealthAndBeautyBusiness</div>
                                <div class="subx3">
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="BeautySalon" <?php checked( 'BeautySalon', $this->nap_settings['nap_type'] ); ?> />BeautySalon</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="HairSalon" <?php checked( 'HairSalon', $this->nap_settings['nap_type'] ); ?> />HairSalon</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="NailSalon" <?php checked( 'NailSalon', $this->nap_settings['nap_type'] ); ?> />NailSalon</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="TattooParlor" <?php checked( 'TattooParlor', $this->nap_settings['nap_type'] ); ?> />TattooParlor</div>
                                </div>
                            <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="HomeAndConstructionBusiness" <?php checked( 'HomeAndConstructionBusiness', $this->nap_settings['nap_type'] ); ?> />HomeAndConstructionBusiness</div>
                                <div class="subx3">
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="Electrician" <?php checked( 'Electrician', $this->nap_settings['nap_type'] ); ?> />Electrician</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="GeneralContractor" <?php checked( 'GeneralContractor', $this->nap_settings['nap_type'] ); ?> />GeneralContractor</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="HousePainter" <?php checked( 'HousePainter', $this->nap_settings['nap_type'] ); ?> />HousePainter</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="HVACBusiness" <?php checked( 'HVACBusiness', $this->nap_settings['nap_type'] ); ?> />HVACBusiness</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="Locksmith" <?php checked( 'Locksmith', $this->nap_settings['nap_type'] ); ?> />Locksmith</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="Plumber" <?php checked( 'Plumber', $this->nap_settings['nap_type'] ); ?> />Plumber</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="RoofingContractor" <?php checked( 'RoofingContractor', $this->nap_settings['nap_type'] ); ?> />RoofingContractor</div>
                                </div>
                            <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="LodgingBusiness" <?php checked( 'LodgingBusiness', $this->nap_settings['nap_type'] ); ?> />LodgingBusiness</div>
                                <div class="subx3">
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="BedAndBreakfast" <?php checked( 'BedAndBreakfast', $this->nap_settings['nap_type'] ); ?> />BedAndBreakfast</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="Hostel" <?php checked( 'Hostel', $this->nap_settings['nap_type'] ); ?> />Hostel</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="Hotel" <?php checked( 'Hotel', $this->nap_settings['nap_type'] ); ?> />Hotel</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="Motel" <?php checked( 'Motel', $this->nap_settings['nap_type'] ); ?> />Motel</div>
                                </div>
                            <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="MedicalOrganization" <?php checked( 'MedicalOrganization', $this->nap_settings['nap_type'] ); ?> />MedicalOrganization</div>
                                <div class="subx3">
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="Dentist" <?php checked( 'Dentist', $this->nap_settings['nap_type'] ); ?> />Dentist</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="Optician" <?php checked( 'Optician', $this->nap_settings['nap_type'] ); ?> />Optician</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="Pharmacy" <?php checked( 'Pharmacy', $this->nap_settings['nap_type'] ); ?> />Pharmacy</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="Physician" <?php checked( 'Physician', $this->nap_settings['nap_type'] ); ?> />Physician</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="VeterinaryCare" <?php checked( 'VeterinaryCare', $this->nap_settings['nap_type'] ); ?> />VeterinaryCare</div>
                                </div>
                            <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="ProfessionalService" <?php checked( 'ProfessionalService', $this->nap_settings['nap_type'] ); ?> />ProfessionalService</div>
                                <div class="subx3">
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="AccountingService" <?php checked( 'AccountingService', $this->nap_settings['nap_type'] ); ?> />AccountingService</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="Attorney" <?php checked( 'Attorney', $this->nap_settings['nap_type'] ); ?> />Attorney</div>
                                </div>
                            <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="RealEstateAgent" <?php checked( 'RealEstateAgent', $this->nap_settings['nap_type'] ); ?> />RealEstateAgent</div>
                            <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="SelfStorage" <?php checked( 'SelfStorage', $this->nap_settings['nap_type'] ); ?> />SelfStorage</div>
                            <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="SportsActivityLocation" <?php checked( 'SportsActivityLocation', $this->nap_settings['nap_type'] ); ?> />SportsActivityLocation</div>
                                <div class="subx3">
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="BowlingAlley" <?php checked( 'BowlingAlley', $this->nap_settings['nap_type'] ); ?> />BowlingAlley</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="ExerciseGym" <?php checked( 'ExerciseGym', $this->nap_settings['nap_type'] ); ?> />ExerciseGym</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="GolfCourse" <?php checked( 'GolfCourse', $this->nap_settings['nap_type'] ); ?> />GolfCourse</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="SkiResort" <?php checked( 'SkiResort', $this->nap_settings['nap_type'] ); ?> />SkiResort</div>
                                </div>
                            <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="Store" <?php checked( 'Store', $this->nap_settings['nap_type'] ); ?> />Store</div>
                                <div class="subx3">
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="BikeStore" <?php checked( 'BikeStore', $this->nap_settings['nap_type'] ); ?> />BikeStore</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="ClothingStore" <?php checked( 'ClothingStore', $this->nap_settings['nap_type'] ); ?> />ClothingStore</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="ComputerStore" <?php checked( 'ComputerStore', $this->nap_settings['nap_type'] ); ?> />ComputerStore</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="ConvenienceStore" <?php checked( 'ConvenienceStore', $this->nap_settings['nap_type'] ); ?> />ConvenienceStore</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="DepartmentStore" <?php checked( 'DepartmentStore', $this->nap_settings['nap_type'] ); ?> />DepartmentStore</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="ElectronicsStore" <?php checked( 'ElectronicsStore', $this->nap_settings['nap_type'] ); ?> />ElectronicsStore</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="FurnitureStore" <?php checked( 'FurnitureStore', $this->nap_settings['nap_type'] ); ?> />FurnitureStore</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="GardenStore" <?php checked( 'GardenStore', $this->nap_settings['nap_type'] ); ?> />GardenStore</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="GroceryStore" <?php checked( 'GroceryStore', $this->nap_settings['nap_type'] ); ?> />GroceryStore</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="HardwareStore" <?php checked( 'HardwareStore', $this->nap_settings['nap_type'] ); ?> />HardwareStore</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="HobbyShop" <?php checked( 'HobbyShop', $this->nap_settings['nap_type'] ); ?> />HobbyShop</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="LiquorStore" <?php checked( 'LiquorStore', $this->nap_settings['nap_type'] ); ?> />LiquorStore</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="OutletStore" <?php checked( 'OutletStore', $this->nap_settings['nap_type'] ); ?> />OutletStore</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="PawnShop" <?php checked( 'PawnShop', $this->nap_settings['nap_type'] ); ?> />PawnShop</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="PetStore" <?php checked( 'PetStore', $this->nap_settings['nap_type'] ); ?> />PetStore</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="ShoeStore" <?php checked( 'ShoeStore', $this->nap_settings['nap_type'] ); ?> />ShoeStore</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="SportingGoodsStore" <?php checked( 'SportingGoodsStore', $this->nap_settings['nap_type'] ); ?> />SportingGoodsStore</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="TireShop" <?php checked( 'TireShop', $this->nap_settings['nap_type'] ); ?> />TireShop</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="ToyStore" <?php checked( 'ToyStore', $this->nap_settings['nap_type'] ); ?> />ToyStore</div>
                                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="WholesaleStore" <?php checked( 'WholesaleStore', $this->nap_settings['nap_type'] ); ?> />WholesaleStore</div>
                                </div>
                            <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="TravelAgency" <?php checked( 'TravelAgency', $this->nap_settings['nap_type'] ); ?> />TravelAgency</div>
                        </div>
                </div>
            <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="Place" <?php checked( 'Place', $this->nap_settings['nap_type'] ); ?> />Place</div>
                <div class="sub">
                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="CivicStructure" <?php checked( 'CivicStructure', $this->nap_settings['nap_type'] ); ?> />CivicStructure</div>
                        <div class="subx2">
                            <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="MusicVenue" <?php checked( 'MusicVenue', $this->nap_settings['nap_type'] ); ?> />MusicVenue</div>
                            <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="PlaceOfWorship" <?php checked( 'PlaceOfWorship', $this->nap_settings['nap_type'] ); ?> />PlaceOfWorship</div>
                            <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="RVPark" <?php checked( 'RVPark', $this->nap_settings['nap_type'] ); ?> />RVPark</div>
                        </div>
                    <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="Residence" <?php checked( 'Residence', $this->nap_settings['nap_type'] ); ?> />Residence</div>
                        <div class="subx2">
                            <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="ApartmentComplex" <?php checked( 'ApartmentComplex', $this->nap_settings['nap_type'] ); ?> />ApartmentComplex</div>
                        </div>
                </div>
            <div><input type="radio" name="<?php echo $this->nap_settings_key; ?>[nap_type]" value="Product" <?php checked( 'Product', $this->nap_settings['nap_type'] ); ?> />Product</div>
        <?php
    }

    function field_nap_name() {
        ?>
        <input type="text" name="<?php echo $this->nap_settings_key; ?>[nap_name]" value="<?php echo esc_attr( $this->nap_settings['nap_name'] ); ?>" />
        <?php
    }

    function field_nap_address() {
        ?>
        <input type="text" name="<?php echo $this->nap_settings_key; ?>[nap_address]" value="<?php echo esc_attr( $this->nap_settings['nap_address'] ); ?>" />
        <?php
    }

    function field_nap_city() {
        ?>
        <input type="text" name="<?php echo $this->nap_settings_key; ?>[nap_city]" value="<?php echo esc_attr( $this->nap_settings['nap_city'] ); ?>" />
        <?php
    }

    function field_nap_state() {
        ?>
        <input type="text" name="<?php echo $this->nap_settings_key; ?>[nap_state]" value="<?php echo esc_attr( $this->nap_settings['nap_state'] ); ?>" />
        <?php
    }

    function field_nap_zip() {
        ?>
        <input type="text" name="<?php echo $this->nap_settings_key; ?>[nap_zip]" value="<?php echo esc_attr( $this->nap_settings['nap_zip'] ); ?>" />
        <?php
    }

    function field_nap_phone() {
        ?>
        <input type="text" name="<?php echo $this->nap_settings_key; ?>[nap_phone]" value="<?php echo esc_attr( $this->nap_settings['nap_phone'] ); ?>" />
        <?php
    }

    function field_nap_hours_schema() {
        ?>
        <input type="text" name="<?php echo $this->nap_settings_key; ?>[nap_hours_schema]" value="<?php echo esc_attr( $this->nap_settings['nap_hours_schema'] ); ?>" />
        <?php
    }

    function field_nap_hours_display() {
        ?>
        <input type="text" name="<?php echo $this->nap_settings_key; ?>[nap_hours_display]" value="<?php echo esc_attr( $this->nap_settings['nap_hours_display'] ); ?>" />
        <?php
    }

    function field_nap_css() {
        ?>
        <textarea rows="6" name="<?php echo $this->nap_settings_key; ?>[nap_css]"><?php echo esc_attr( $this->nap_settings['nap_css'] ); ?></textarea>
        <?php
    }

    function add_admin_menus() {
        add_options_page( 'Little Google Tools', 'Little Google Tools', 'manage_options', $this->lgt_options_key, array( &$this, 'lgt_options_page' ) );
    }

    function lgt_options_page() {
        $tab = isset( $_GET['tab'] ) ? $_GET['tab'] : $this->ga_settings_key;
        ?>
        <style>
            .form-table div.subt {margin-top:6px;font-size:10px;color:#666666;}
            .form-table td div {margin:12px 0!important;color:#000000;}
            .form-table td div:first-child {margin:6px 0 12px!important;}
            .form-table td div.sub {margin-left:9px!important;padding-left:24px;color:#333333;border-left:1px dotted #333333;}
            .form-table td div.subx2 {margin-left:6px!important;padding-left:24px;color:#666666;border-left:1px dotted #666666;}
            .form-table td div.subx3 {margin-left:6px!important;padding-left:24px;color:#999999;border-left:1px dotted #999999;}
            .form-table td div.sub input[type="radio"], .lgt-form-table td div.subx2 input[type="radio"], .form-table td div.subx3 input[type="radio"] {zoom:100%!important;margin-top:-2px!important;}
            .form-table input[type="text"], .form-table textarea {border:2px solid #cccccc!important;width:280px!important;margin-top:-2px!important;}
            .form-table input[type="checkbox"], .form-table input[type="radio"] {zoom:138%;margin-top:-1px;}
            h2.nav-tab-wrapper {margin-bottom:15px;}
            h3 {padding:12px;border-radius:6px;background: -moz-linear-gradient(left,  rgba(140,180,200,1) 0%, rgba(163,195,211,0) 20%, rgba(255,255,255,0) 100%);background: -webkit-gradient(linear, left top, right top, color-stop(0%,rgba(140,180,200,1)), color-stop(20%,rgba(163,195,211,0)), color-stop(100%,rgba(255,255,255,0)));background: -webkit-linear-gradient(left,  rgba(140,180,200,1) 0%,rgba(163,195,211,0) 20%,rgba(255,255,255,0) 100%);background: -o-linear-gradient(left,  rgba(140,180,200,1) 0%,rgba(163,195,211,0) 20%,rgba(255,255,255,0) 100%);background: -ms-linear-gradient(left,  rgba(140,180,200,1) 0%,rgba(163,195,211,0) 20%,rgba(255,255,255,0) 100%);background: linear-gradient(to right,  rgba(140,180,200,1) 0%,rgba(163,195,211,0) 20%,rgba(255,255,255,0) 100%);filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#8cb4c8', endColorstr='#00ffffff',GradientType=1 );}
            .codediv {width: 90%;margin:24px auto 0;padding:12px;font-size:10px;border:1px solid #cccccc;background:#eeeeee;}
        </style>
        <div class="wrap">
            <h1>Little Google Tools</h1>
            <?php $this->lgt_options_tabs(); ?>
            <form method="post" action="options.php">
                <?php wp_nonce_field( 'update-options' ); ?>
                <?php settings_fields( $tab ); ?>
                <?php do_settings_sections( $tab ); ?>
                <?php submit_button(); ?>
            </form>
        </div>
        <?php
    }

    function lgt_options_tabs() {
        $current_tab = isset( $_GET['tab'] ) ? $_GET['tab'] : $this->ga_settings_key;
        screen_icon();
        echo '<h2 class="nav-tab-wrapper">';
        foreach ( $this->lgt_settings_tabs as $tab_key => $tab_caption ) {
            $active = $current_tab == $tab_key ? 'nav-tab-active' : '';
            echo '<a class="nav-tab ' . $active . '" href="?page=' . $this->lgt_options_key . '&tab=' . $tab_key . '">' . $tab_caption . '</a>';
        }
        echo '</h2>';
    }

}
add_action( 'plugins_loaded', create_function( '', '$settings_little_google_tools = new Settings_Little_Google_Tools;' ) );

add_action( 'wp_head', 'lgt_ga' );
function lgt_ga() {
    $options_ga = get_option( 'lgt_ga_settings' );
    if ( isset($options_ga['ga_enabled']) && $options_ga['ga_enabled'] != 0 ) { ?>
    <script>
        (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
        (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
        m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
        })(window,document,'script','//www.google-analytics.com/analytics.js','ga');
        ga('create', '<?php echo $options_ga['ga_id']; ?>', 'auto');
        <?php if ( isset($options_ga['ga_display_advertising_features']) && $options_ga['ga_display_advertising_features'] != 0 ) { ?>
ga('require', 'displayfeatures');
        <?php } ?>
ga('send', 'pageview');
    </script>
    <?php }
}

add_action( 'wp_print_styles', 'lgt_fonts' );
function lgt_fonts() {
    $options_gf = get_option( 'lgt_gf_settings' );
    if ( isset($options_gf['gf_enabled']) && $options_gf['gf_enabled'] != 0 ) {
        $gf_fonts = $options_gf['gf_fonts'];
		if ( $gf_fonts != '' ) {
			wp_register_style('lgt-fonts', '//fonts.googleapis.com/css?family='.$gf_fonts, array(), null);
			wp_enqueue_style( 'lgt-fonts' );
		}
    }
}

$options_nap = get_option( 'lgt_nap_settings' );
$nap_markup_location = $options_nap['nap_markup_location'];
add_shortcode( 'nap_schema', 'lgt_nap' );
if ( $nap_markup_location != '' ) {
    add_action( $nap_markup_location, 'lgt_nap' );
}
function lgt_nap() {
    $options_nap = get_option( 'lgt_nap_settings' );
    if ( isset($options_nap['nap_enabled']) && $options_nap['nap_enabled'] != 0 ) {
        echo '<style>.footer-schema{', $options_nap['nap_css'] ,'}</style>',"\n";
        echo "\t\t\t\t\t\t\t",'<div class="footer-schema" style="text-align:center;" itemscope itemtype="http://schema.org/', $options_nap['nap_type'] ,'">',"\n";
        if ( $options_nap['nap_name'] != '' ) { echo "\t\t\t\t\t\t\t\t",'<strong><span itemprop="name">', $options_nap['nap_name'] ,'</span></strong><br />',"\n"; }
        if ( $options_nap['nap_phone'] != '' ) { echo "\t\t\t\t\t\t\t\t",'<span itemprop="telephone">', $options_nap['nap_phone'] ,'</span>',"\n"; }
        if ( $options_nap['nap_address'] || $options_nap['nap_city'] || $options_nap['nap_state'] || $options_nap['nap_zip'] != '' ) {
            echo "\t\t\t\t\t\t\t\t",'<div itemprop="address" itemscope itemtype="http://schema.org/PostalAddress">',"\n";
                if ( $options_nap['nap_address'] != '' ) { echo "\t\t\t\t\t\t\t\t\t",'<span itemprop="streetAddress">', $options_nap['nap_address'] ,'</span> ',"\n"; }
                if ( $options_nap['nap_city'] != '' ) { echo "\t\t\t\t\t\t\t\t\t",'<span itemprop="addressLocality">', $options_nap['nap_city'] ,'</span>, ',"\n"; }
                if ( $options_nap['nap_state'] != '' ) { echo "\t\t\t\t\t\t\t\t\t",'<span itemprop="addressRegion">', $options_nap['nap_state'] ,'</span> ',"\n"; }
                if ( $options_nap['nap_zip'] != '' ) { echo "\t\t\t\t\t\t\t\t\t",'<span itemprop="postalCode">', $options_nap['nap_zip'] ,'</span>',"\n"; }
            echo "\t\t\t\t\t\t\t\t",'</div>',"\n";
        }
        if ( $options_nap['nap_hours_schema'] && $options_nap['nap_hours_display'] != '' ) { echo "\t\t\t\t\t\t\t\t",'<time itemprop="openingHours" datetime="', $options_nap['nap_hours_schema'] ,'">', $options_nap['nap_hours_display'] ,'</time>',"\n"; }
        echo "\t\t\t\t\t\t\t",'</div>',"\n";
    }
}